
/dobot/bin/logServer &

#update
BPARAM_DEV_TYPE="M1Pro"
FwUpdateType=NONE
FwUpdatePath=/dobot/userdata/project/bin.tar.gz
if [ -f "/dobot/userdata/project/bin.tar.gz" ]; then
	FwUpdateType=SC
elif [ -f "/udisk/${BPARAM_DEV_TYPE}_Controller.tar.gz" ]; then
	FwUpdateType=USB
	cp /udisk/${BPARAM_DEV_TYPE}_Controller.tar.gz /dobot/userdata/project/bin.tar.gz
	mv /udisk/${BPARAM_DEV_TYPE}_Controller.tar.gz /udisk/${BPARAM_DEV_TYPE}_Controller.tar.gz.bk
fi

if [ ${FwUpdateType} != NONE ];then
	#校验升级包
	cd /dobot/userdata/project
	split -b $(expr $(ls ${FwUpdatePath} -l | awk '{print $5}') - 1024) ${FwUpdatePath} pack_
	echo `cat pack_ab | cut -c 1-32`\ \ pack_aa > md5
	md5sum -c md5 -s

	if [ $? != 0 ];then
		echo "MD5 of Pack is Invalid!!!"
		FwUpdateType=NONE
	fi

	if [ $(cat pack_ab | cut -c 35-39) != "${BPARAM_DEV_TYPE}" ];then
		echo "Type of Pack is Invalid!!!"
		FwUpdateType=NONE
	fi

	mv pack_aa ${FwUpdatePath}
	rm md5 pack_ab
fi

if [ ${FwUpdateType} != NONE ];then
	#清理旧文件
	cd /dobot/
	rm /dobot/bin/ -rf
	rm -rf /dobot/userdata/project/firmware/

	#解包更新
	tar zxvf ${FwUpdatePath} -C /dobot
	if [ ${FwUpdateType} == SC ];then
		rm -f ${FwUpdatePath}
	elif [ ${FwUpdateType} == USB ];then
		mv ${FwUpdatePath} ${FwUpdatePath}.bak
	fi
	if [ -d "/dobot/system/home/ftp/PlcLogic/Application" ];then
		cp -rf /dobot/system/home/ftp/PlcLogic/Application /home/ftp/PlcLogic
		rm -rf /dobot/system/
	fi
	if [ -f "/dobot/package/afterUpdate.sh" ];then
		chmod +x /dobot/package/afterUpdate.sh
		/dobot/package/afterUpdate.sh
		rm /dobot/package/afterUpdate.sh
	fi
	sync

	#等待重启
	echo "..... update finish,reboot"
	reboot
	while true
	do
		echo "wait for reboot .."
		sleep 1
	done
fi

if [ -d "/home/ovalgee/Projects/RobotController_4R/project/Robot4Axis_win/bin" ]; then
	topdir=/home/ovalgee/Projects/RobotController_4R/project/Robot4Axis_win/bin
	export PATH=/home/ovalgee/Projects/toolchain/arm-linux-gcc-6.3.1/bin:/home/ovalgee/Projects/iSCARA/Linux/toolchain/i686-linux-gcc-5.1.0/bin:$PATH
	export LD_LIBRARY_PATH=/home/ovalgee/Projects/toolchain/i686-linux-gcc-5.1.0/lib:$LD_LIBRARY_PATH
	qtdir=$topdir/lib/qt
elif [ -d "/home/ovalgee/Projects/iSCARA/RobotController_4R/trunk/RobotController/Linux/project/Robot4Axis_win/bin" ]; then
	topdir=/home/ovalgee/Projects/iSCARA/RobotController_4R/trunk/RobotController/Linux/project/Robot4Axis_win/bin
	export PATH=/home/ovalgee/Projects/iSCARA/Linux/toolchain/arm-linux-gcc-6.3.1/bin:/home/ovalgee/Projects/iSCARA/Linux/toolchain/i686-linux-gcc-5.1.0/bin:$PATH
	export LD_LIBRARY_PATH=/home/ovalgee/Projects/iSCARA/Linux/toolchain/i686-linux-gcc-5.1.0/lib:$LD_LIBRARY_PATH
	qtdir=$topdir/lib/qt
elif [ -d "/dobot/bin" ]; then
	topdir=/dobot/bin
	qtdir=/usr/local/qt-4.8.6
else
	echo "You must indicat path"
	exit 1
fi

tmpdir=$topdir/tmp

export LD_LIBRARY_PATH=$topdir/lib:$qtdir/lib:/usr/local/samba/lib:$LD_LIBRARY_PATH
export PATH=$PYTHONHOME/bin:/usr/local/samba/bin:/usr/local/samba/sbin:$PATH

export LUA_PATH=$topdir/lua/?.lua
export LUA_CPATH=$topdir/lib/?.so

#clean tmp dir
rm -rf $tmpdir
mkdir -p $tmpdir
mkdir -p $tmpdir/smb
rm -f /project
ln -s /dobot/userdata/project /project

#check dir
if [ ! -d "log" ]; then
	mkdir log
fi
if [ ! -f "$topdir/etc/version.conf" ]; then
	echo "010000" > $topdir/etc/version.conf
fi

#log setting
tty2file_option=""
logcntfile=$topdir/log/cnt.conf
logtypefile=$topdir/log/type.conf
logtempfile=/tmp/log_temp.conf
if [ ! -f "$logtypefile" ]; then
	echo file > $logtypefile
fi
logtype=$(cat ${logtypefile}) #stdout, socket, file
if [ -f "$logcntfile" ]; then
	logcnt=`awk '{print NR}' ${logcntfile}|tail -n1`
	allcount=`head -1 ${logcntfile}`
	if [ $logcnt -gt $allcount ]; then
		delfile=`sed -n '2p' ${logcntfile}`
		sed -i '2d' $logcntfile;
		rm -rf log/$delfile
	fi
fi
#  change mac to setted
if [ -f "/etc/mac" ]; then
	echo set mac to $(cat /etc/mac)
	/sbin/ifconfig eth2 down
	/sbin/ifconfig eth2 hw ether $(cat /etc/mac)
	/sbin/ifconfig eth2 up
	/sbin/ifconfig eth1 down
	/sbin/ifconfig eth1 hw ether $(cat /etc/mac)
	/sbin/ifconfig eth1 up
fi
#start smb
nmbd -s /usr/local/samba/lib/smb.conf -D &
smbd -s /usr/local/samba/lib/smb.conf -D &

#选择是否开启dhcp
dhcpflag=`grep eth2_dhcp /dobot/userdata/project/settings/iscara.conf | awk -F '=' '{print $2}'`
echo $dhcpflag

if [[ $dhcpflag == "true" ]]; then
	udhcpc -b -i eth2 -p /var/run/lan_udhcpc.pid -R  # 2021-09-01 add udhcpc run in back
else
	#判断是否修改网关
	ipflag=`grep eth2_ip /dobot/userdata/project/settings/iscara.conf | awk -F '=' '{print $2}'`
	gwflag=`grep eth2_gw /dobot/userdata/project/settings/iscara.conf | awk -F '=' '{print $2}'`
	maskflag=`grep eth2_mask /dobot/userdata/project/settings/iscara.conf | awk -F '=' '{print $2}'`
	echo $ipflag
	echo $gwflag
	echo $maskflag

	if [[ $ipflag == "" || $gwflag == "" || $maskflag == "" ]]; then
		chattr -i /etc/resolv.conf
		rm /etc/resolv.conf
    	echo "nameserver 127.0.0.1" > /etc/resolv.conf
		chattr +i /etc/resolv.conf
		ifconfig eth2 192.168.2.6 netmask 255.255.255.0
		route add -net 192.168.2.0/24 gw 192.168.2.6 eth2
		sleep 2
	else
		chattr -i /etc/resolv.conf
		rm /etc/resolv.conf
		echo "nameserver 127.0.0.1" > /etc/resolv.conf
		chattr +i /etc/resolv.conf
		ifconfig eth2 $ipflag netmask $maskflag
		route add default gw $gwflag
		sleep 2
    fi
fi

chmod +x /dobot/bin/gcontrol
/dobot/bin/gcontrol | /dobot/bin/logTerminal 0 gcontrol &

if [ -f /udisk/FactoryPCBATest.tgz ]; then
	cp /udisk/FactoryPCBATest.tgz /tmp
	cd /tmp
	tar xzf FactoryPCBATest.tgz
	chmod +x /tmp/testCode/*
	/tmp/testCode/startTest.sh &
	cd -
fi

option="${1}"
case ${option} in
    -codesys)
        echo "[start] codesys"
	      if [ "$logtype" == "file" ]; then
	      	if [ ! -f "$logcntfile" ]; then
	 			echo 30 > $logcntfile
	  		fi
	  		logf=`cat /dev/urandom | head -n 10 | md5sum | head -c 10`
	     	echo $logf >> $logcntfile
	 		echo $logf > $logtempfile
			tty2file_option="2>&1 > /var/tty2file_Log.log"
	 		sync
	      fi
        cd /opt/codesys/Platforms/Linux/Bin
        ./codesysload | /dobot/bin/logTerminal 0 codesys &
        ;;
   -env)
	 echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"
	 echo "PATH=$PATH"
      ;;
   -dobot)
      echo "[start] iscara"
      if [ "$logtype" == "file" ]; then
      	if [ ! -f "$logcntfile" ]; then
 			echo 30 > $logcntfile
  		fi
  		logf=`cat /dev/urandom | head -n 10 | md5sum | head -c 10`
     	echo $logf >> $logcntfile
 		echo $logf > $logtempfile
 		sync
      fi
	  ./iscara
	  ;;
	-clog)
		echo "[start] clear all log"
	  	if [ -f "$logcntfile" ]; then
			allcount=1
			if [ "$logtype" == "file" ]; then
				allcount=2
			fi
			logcnt=`awk '{print NR}' ${logcntfile}|tail -n1`
			while [[ $logcnt -gt $allcount ]]
			do
				delfile=`sed -n '2p' ${logcntfile}`
				sed -i '2d' $logcntfile
				if [ -f "log/$delfile" ]; then
					rm -rf log/$delfile
				fi
				logcnt=`awk '{print NR}' ${logcntfile}|tail -n1`
			done
		fi
	  ;;
   *)
	  echo "`basename ${0}`:usage: "
	  echo "codesys"	"start codesys"
	  echo "[-env]   	echo current environment"
	  echo "[-dobot]  	start scara"
	  echo "[-clog]   	clear all log"
      exit 1 # Command to come out of the program with status 1
      ;;

esac
chmod +x /dobot/bin/autoCacheFree.sh
/dobot/bin/autoCacheFree.sh &