--[[
	data persistence
--]]

local m = {}
local json = require("luaJson")

--[[
    @brief init persistence
    @param path file path
--]]
function m.init(path)
    g_is_save_args_process = false
    global_var_saver = persistence.saveArgs
    global_var_file = path
end

--[[
    @brief load variables to _G
    @param path file path
--]]
function m.loadArgs()
    local json_str = m.loadFile(global_var_file)
    if json_str == nil then
        return
    end
    local lua_json = json.decode(json_str)

    for key, value in pairs(lua_json) do
        _G[key] = value["value"]
    end
end

--[[
    @brief save args to file
    @param path file path
    @param force if it's set, then fore write all variables to file without checking the variables is the same. 
    otherwise it would write variables to file just when the variables has changed
--]]
function m.saveArgs(force)
    if g_is_save_args_process then
        return
    end

    g_is_save_args_process = true
    local json_str = m.loadFile(global_var_file)
    if json_str == nil then
        --print("has no global file")
        g_is_save_args_process = false
        return
    end
    local lua_json = json.decode(json_str)
    
    if not force and not m.hasChanged(_G, lua_json) then
        -- fore: false
        -- hasChanged: false
        --print("nothing to do.....................")
        g_is_save_args_process = false
        return
    end

    for key, value in pairs(lua_json) do
        if value["globalHold"] == true then
            value["value"] = _G[key]
        end
    end

    --print("save to file........................")

    local str = json.encode(lua_json)
    m.saveFile(global_var_file, str)
    g_is_save_args_process = false
end

--[[
    @brief enable auto save
    @param period period
--]]
function m:enableAutoSave(period)
    self.period = period
    Sleep(10)
    systhread.create(m.taskProc, self)
end


function m:taskProc()
    while true do
        m.saveArgs()
        Sleep(self.period)
    end
end

function m.isTableNEQ(tab1, tab2)
    for key, value in pairs(tab1) do
        if type(value) ~= "table" then
            if value ~= tab2[key] then
                -- print("neq", value, tab2[key])
                return true
            end
        else
            if m.isTableNEQ(value, tab2[key]) then
                return true
            end
        end
    end
    return false
end

function m.hasChanged(_new, _old)
    for key, value in pairs(_old) do
        if value["globalHold"] == true then
            local v = value["value"]
            if type(v) ~= "table" then
                if value["value"] ~= _G[key] then
                    return true
                end
            else
                if m.isTableNEQ(v, _G[key]) then
                    return true
                end
            end
        end
    end

    return false
end

function m.loadFile(filename)
    local file, err
    file, err = io.open(filename, "rb")
    if file == nil then
        return nil
    end
    local data = file:read("*a")

    file:close()

    if data == "" then
        return nil
    end

    return data
end

function m.saveFile(filename, data)
    local file, err
    file, err = io.open(filename, "wb")
    if file == nil then
        error(("Unable to write '%s': %s"):format(filename, err))
    end
    file:write(data)
    if filename ~= nil then
        file:close()
    end
end

return m
