dType.SetPTPCommonParamsEx(api,250,250,1)
dType.SetPTPCoordinateParamsEx(api,250,250,250,250,1)
dType.SetPTPJointParamsEx(api,250,250,250,250,250,250,250,250,1)
dType.SetEndEffectorParamsEx(api, 59.7, 0, 0, 1)

def arm_move(x, y, z, r):
  current_pose = dType.GetPose(api)
  dType.SetPTPCmdEx(api, 2, x,  y,  z, r, 1)

def gripper(on, grip):
  dType.SetEndEffectorGripperEx(api, on, grip)

def wait(sec):
  dType.SetWAITCmdEx(api, sec, 1)

def get_domino(add_x):
  # idou
  arm_move(  200 + (add_x * 7),    0,    50,   90 )
  arm_move(  200 + (add_x * 7),  130,    50,   90 )
  # hiraku
  gripper(1, 0)
  # orosu
  arm_move(  200 + (add_x * 7),  130,    -5,   90 )
  # tojiru
  gripper(1, 1)
  wait(1)
  arm_move(  200 + (add_x * 7),  130,    50,   90 )

def put_domino(x, y, z, r):
  # oku
  arm_move(  x,    50 + y,    50,    r )
  arm_move(  x,    50 + y,    -5,    r )
  # hiraku
  gripper(1, 0)
  wait(1)
  arm_move(  x,    50 + y,    50,    r )

def put_domino_2(x):
  # oku
  arm_move(  150,  130,    50,    0 )
  arm_move(  150,  130,    -5,    0 )
  # hiraku
  gripper(1, 0)
  wait(1)
  arm_move(  160 - x,  130,    50,    90 )
  # hiraku
  gripper(1, 0)
  wait(1)
  # orosu
  arm_move(  160 - x,  130,    -5,   90 )
  # tojiru
  gripper(1, 1)
  wait(1)
  arm_move(  160 - x,  130,    50,   90 )


y = -25
row = 0

arm_move(  200, 0, 0, 0 )

# 0
get_domino(row)
put_domino(230,0,0,0)

row = row + 1

# 1
get_domino(1)
put_domino_2(20)
put_domino(205,y * row,0,90)

get_domino(2)
put_domino_2(0)
put_domino(255,y * row,0,90)

row = row + 1

# 2
get_domino(3)
put_domino(205,y * row,0,0)

get_domino(4)
put_domino(255,y * row,0,0)

row = row + 1

# 3
get_domino(5)
put_domino(197,y * row,0,30)

get_domino(6)
put_domino(263,y * row,0,-30)

row = row + 1

# 4
get_domino(7)
put_domino(183,y * row,0,0)

get_domino(8)
put_domino(277,y * row,0,0)

get_domino(9)
put_domino_2(0)
put_domino(220,y * row,0,90)

get_domino(10)
put_domino_2(20)
put_domino(240,y * row,0,90)

row = row + 1

# 5
get_domino(11)
put_domino_2(0)
put_domino(222,y * row,0,90)

get_domino(12)
put_domino_2(20)
put_domino(230,y * row,0,90)

row = row + 1

# 6
get_domino(13)
put_domino(230,y * row,0,0)

row = row + 1

# 7
get_domino(14)
put_domino(230,y * row,0,0)

row = row + 1


# taosu
wait(1)
arm_move( 230, 100,  50, 0 )
arm_move( 230, 100,  -5, 0 )
gripper(1, 1)

wait(2)
arm_move( 230,  40,  -5, 0 )
arm_move( 230, 100,  50, 0 )

# end
gripper(0, 0)
