dType.SetDeviceWithL(api, 1, 0)
dType.SetJOGJointParams(api, 100, 100, 100, 100, 100, 100, 100, 100)

# @brief 腕、レールはこれで動かす
def move(x, y, z, r, rails):
	dType.SetPTPWithLCmdEx(api, 1, x, y, z, r, rails, 1)

# @brief 掴む
# @param[in] on 掴むためのポンプ起動
# @param[in] grip 掴むor離す
def gripper(on, grip):
	dType.SetEndEffectorGripperEx(api, on, grip)
	
# @brief 指定した秒数まで待機
# @param[in] sec 待機する秒数
def wait(sec):
	dType.SetWAITCmdEx(api, sec, 1)

# @brief 指定したカードの座標までレールを移動させる
# @param[in] id カードの位置
def movetoCardPos(id):
	rails_pos = card_pos + card_space * id
	move(arm_x, arm_y, arm_z, arm_r, rails_pos)

current_pose = dType.GetPose(api)

arm_x = 200
arm_y = 0
arm_z = 0
arm_r = -90

card_pos = 110
card_space = 70


rails_pos = 0;
dType.SetPTPWithLCmdEx(api, 1, arm_x, arm_y, arm_z, arm_r, rails_pos, 1)

# どれにしようかな～
for i in range(4):
	rails_pos = card_pos + card_space * i
	move(arm_x, arm_y, arm_z, arm_r, rails_pos)
	wait(0.2)

# カードを取る！
gripper(1, 0)
wait(0.2)

arm_x = 245
arm_z = 20
move(arm_x, arm_y, arm_z, arm_r, rails_pos)
wait(0.2)

arm_x = 245
arm_z = -30
move(arm_x, arm_y, arm_z, arm_r, rails_pos)
wait(0.2)

arm_x = 270
arm_z = -30
move(arm_x, arm_y, arm_z, arm_r, rails_pos)
wait(0.2)

gripper(1, 1)
wait(1)

arm_x = 270
arm_z = 50
move(arm_x, arm_y, arm_z, arm_r, rails_pos)
wait(0.2)

# 自分側に向ける
arm_r = 90
move(arm_x, arm_y, arm_z, arm_r, rails_pos)
wait(0.2)

# 自分の手札まで持ってくる
arm_x = 143
arm_y = -81
arm_z = 44
move(arm_x, arm_y, arm_z, arm_r, rails_pos)

# 腕を下ろす
arm_x = 161
arm_y = -86
arm_z = -30
move(arm_x, arm_y, arm_z, arm_r, rails_pos)
wait(0.2)

# 掴んだカードを離す
gripper(1, 0)
wait(0.2)

arm_z = 40
move(arm_x, arm_y, arm_z, arm_r, rails_pos)

gripper(0, 0)